/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.report.urgentpath.AuthorizationWaiting;
import cz.insophy.inplan.report.urgentpath.CapacityWaiting;
import cz.insophy.inplan.report.urgentpath.InitialWaitingAnalyzers;
import cz.insophy.inplan.report.urgentpath.MaterialWaiting;
import cz.insophy.inplan.report.urgentpath.Production;
import cz.insophy.inplan.report.urgentpath.ReleaseDateWaiting;
import cz.insophy.inplan.report.urgentpath.ToolWaiting;
import cz.insophy.inplan.report.urgentpath.UrgentPathInfoBuilder;
import cz.insophy.inplan.report.urgentpath.Waiting;
import cz.insophy.inplan.report.urgentpath.WaitingVisitor;
import cz.insophy.inplan.sdgraph.MaterialSource;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class UrgentPathInfo {
    private final CustomerRequest cr;
    private final long fixationDate;
    private final MaterialSource crMaterialSource;
    private final long crFinishedTime;
    private final ImmutableList<GeneralizedActionRequest> gars;
    private final Map<GeneralizedOrderRequest, Double> mtoQtys;
    private final ImmutableMap<GeneralizedActionRequest, ReleaseDateWaiting> releaseDateWaiting;
    private final ImmutableMap<GeneralizedActionRequest, AuthorizationWaiting> authorizationWaiting;
    private final ImmutableMap<GeneralizedActionRequest, CapacityWaiting> capacityWaiting;
    private final ImmutableMap<GeneralizedActionRequest, ToolWaiting> toolWaiting;
    private final MaterialWaiting materialWaiting;
    private final ImmutableMap<GeneralizedActionRequest, Production> production;
    private final long totalWaitingTime;
    private final long totalProductionTime;

    public static UrgentPathInfoBuilder builder(Superplan superplan) {
        return UrgentPathInfo.builder(superplan, InitialWaitingAnalyzers.QUOTA);
    }

    public static UrgentPathInfoBuilder builder(Superplan superplan, InitialWaitingAnalyzers initialWaitingAnalyzer) {
        return new UrgentPathInfoBuilder(superplan, initialWaitingAnalyzer);
    }

    public UrgentPathInfo(List<GeneralizedActionRequest> gars, Map<GeneralizedActionRequest, Production> production, MaterialWaiting materialWaiting, Map<GeneralizedActionRequest, CapacityWaiting> capacityWaiting, Map<GeneralizedActionRequest, ToolWaiting> toolWaiting, Map<GeneralizedActionRequest, ReleaseDateWaiting> releaseDateWaiting, Map<GeneralizedActionRequest, AuthorizationWaiting> authorizationWaiting, Map<GeneralizedOrderRequest, Double> mtoQtys, long fixationDate, CustomerRequest cr, MaterialSource crMaterialSource, long crFinishedTime) {
        this.production = ImmutableMap.copyOf(production);
        this.materialWaiting = materialWaiting;
        this.capacityWaiting = ImmutableMap.copyOf(capacityWaiting);
        this.toolWaiting = ImmutableMap.copyOf(toolWaiting);
        this.releaseDateWaiting = ImmutableMap.copyOf(releaseDateWaiting);
        this.authorizationWaiting = ImmutableMap.copyOf(authorizationWaiting);
        this.gars = ImmutableList.copyOf(gars);
        this.mtoQtys = ImmutableMap.copyOf(mtoQtys);
        this.fixationDate = fixationDate;
        this.cr = cr;
        this.crMaterialSource = crMaterialSource;
        this.crFinishedTime = crFinishedTime;
        long prodTime = 0L;
        for (Production prod : production.values()) {
            prodTime += prod.getLength() + prod.getLogisticTime();
        }
        this.totalProductionTime = prodTime;
        long waitTime = materialWaiting == null ? 0L : materialWaiting.getLength();
        for (CapacityWaiting cw : capacityWaiting.values()) {
            waitTime += cw.getLength();
        }
        for (AuthorizationWaiting aw : authorizationWaiting.values()) {
            waitTime += aw.getLength();
        }
        this.totalWaitingTime = waitTime;
    }

    public long getFixationDate() {
        return this.fixationDate;
    }

    public CustomerRequest getCr() {
        return this.cr;
    }

    public MaterialSource getCrMaterialSource() {
        return this.crMaterialSource;
    }

    public long getCrFinishedTime() {
        return this.crFinishedTime;
    }

    public boolean isCrDelayed() {
        return this.getCrDelay() > 0L;
    }

    public long getCrDelay() {
        return this.crFinishedTime - this.cr.getTime();
    }

    public long getCrTime() {
        return this.cr.getTime();
    }

    public ImmutableList<GeneralizedOrderRequest> getGors() {
        LinkedHashSet<GeneralizedOrderRequest> gors = Sets.newLinkedHashSet();
        for (GeneralizedActionRequest gar : this.gars) {
            gors.add(ProductionTreeAlgorithms.getNearestGor(gar));
        }
        return ImmutableList.copyOf(gors);
    }

    public List<GeneralizedActionRequest> getGarsOfGor(String gorId) {
        ArrayList<GeneralizedActionRequest> res = Lists.newArrayList();
        for (GeneralizedActionRequest gar : this.gars) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            if (gor == null || !gor.getId().equals(gorId)) continue;
            res.add(gar);
        }
        return res;
    }

    public ImmutableList<GeneralizedActionRequest> getGars() {
        return this.gars;
    }

    public double getGorMtoQty(GeneralizedOrderRequest gor) {
        return this.mtoQtys.get(gor);
    }

    public ReleaseDateWaiting getReleaseDateWaiting(GeneralizedActionRequest gar) {
        return this.releaseDateWaiting.get(gar);
    }

    public AuthorizationWaiting getAuthorizationWaiting(GeneralizedActionRequest gar) {
        return this.authorizationWaiting.get(gar);
    }

    public MaterialWaiting getMaterialWaiting() {
        return this.materialWaiting;
    }

    public CapacityWaiting getCapacityWaiting(GeneralizedActionRequest gar) {
        return this.capacityWaiting.get(gar);
    }

    public ToolWaiting getToolWaiting(GeneralizedActionRequest gar) {
        return this.toolWaiting.get(gar);
    }

    public Production getProduction(GeneralizedActionRequest gar) {
        return this.production.get(gar);
    }

    public Collection<Waiting> getAllWaitings() {
        ArrayList<Waiting> res = Lists.newArrayListWithCapacity(1 + this.authorizationWaiting.size() + this.capacityWaiting.size() + this.toolWaiting.size());
        if (this.materialWaiting != null) {
            res.add(this.materialWaiting);
        }
        res.addAll(this.authorizationWaiting.values());
        res.addAll(this.capacityWaiting.values());
        res.addAll(this.toolWaiting.values());
        return res;
    }

    public void accept(WaitingVisitor visitor) {
        for (Waiting waiting : this.getAllWaitings()) {
            waiting.accept(visitor);
        }
    }

    public long getTotalWaitingTime() {
        return this.totalWaitingTime;
    }

    public long getTotalProductionTime() {
        return this.totalProductionTime;
    }

    public double getValueAddedIndex() {
        return (double)this.getTotalProductionTime() / ((double)this.getTotalWaitingTime() + (double)this.getTotalProductionTime());
    }
}

